<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Comptes extends Model 
{

    protected $table = 'comptes';
    public $timestamps = true;
    protected $fillable = array('typecompte_id', 'institution_id', 'fournisseur_id', 'begda', 'endda', 'nom', 'numero', 'solde_depart', 'solde', 'budget', 'engagement', 'disponible');

    public function comptetypes()
    {
        return $this->belongsTo('App\Models\Comptetype');
    }

    public function intitutions()
    {
        return $this->belongsTo('App\Models\Institution');
    }

    public function comptetrans()
    {
        return $this->hasMany('App\Models\Transaction', 'compte_id');
    }

    public function comptebudget()
    {
        return $this->hasMany('App\Models\Budget', 'compte_id');
    }

    public function comptefournisseurs()
    {
        return $this->belongsTo('App\Models\Fournisseurs');
    }

}